{AboutDlg Component

by Dana Scott Kaufman
Apogee Information Systems
for Delphi Developers Group
8/21/95}
unit Aboutdlg;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  {The About Form created graphically with the
  Delphi IDE}
  TAboutForm = class(TForm)
    Image1: TImage;
    ProductNameLabel: TLabel;
    BitBtn1: TBitBtn;
    CopyrightLabel: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  { Wrapper around the About Form that displays the
   form and also gets the properties as a component. This
   class gets Registered with Delphi}
  TAboutDlg = class(TComponent)
  private
    { Private declarations }
    FPicture: TPicture; {Temporary storage for picture}
    FProductName: String;
    FCopyright: String;
    procedure SetPicture(Value: TPicture);
  protected
    { Protected declarations }
  public
    { Public declarations }
    function Execute: Boolean;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy;
  published
    { Published declarations }
    property Picture: TPicture read FPicture write SetPicture; {SetPicture is function}
    property ProductName: String read FProductName write FProductName;
    property Copyright: String read FCopyright write FCopyright;
  end;

var
  AboutForm: TAboutForm;

procedure Register;

implementation

{$R *.DFM}

{Register the Component with Delphi}
procedure Register;
begin
  RegisterComponents('Demo', [TAboutDlg]);
end;

{Constructor used to allocate the Picture}
constructor TAboutDlg.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FPicture := TPicture.Create; {Create Picture}
end;

{Destructor to clean up}
destructor TAboutDlg.Destroy;
begin
  FPicture.Free; {Destroy picture}
  inherited Destroy;
end;

{Function called when the Picture property is changed}
{Assign FPicture to the slected picture}
procedure TAboutDlg.SetPicture(Value: TPicture);
begin
  FPicture.Assign(Value);
end;

{ This function creates the About Form, puts the appropriate values on the
	Form, displays it and then Frees the form.  It returns true if the form
  was exited with te OK button and false if it was exited by closing}
function TAboutDlg.Execute: Boolean;
var
	AboutForm: TAboutForm;
begin
  try
   AboutForm:=TAboutForm.Create(self); { Create about form }
  with AboutForm do
    begin
      {Assign picture on main form to one selected in the Object Inspector}
      Image1.Picture.Assign(FPicture);
      CopyrightLabel.Caption:=FCopyright;

      {Display AboutForm and check results}
      if ShowModal=mrOK then
    	  Result:=True
      else
    	  Result:=False;
    end;
  finally
  	AboutForm.Free; {Free About Form}
  end;
end;

end.
